﻿//////////////////////////////////////////////
// BoundingBox.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Frustum ;
	class Node ;
}

namespace nkMaths
{
	class Matrix ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT BoundingBox final
	{
		public :

			// Constructors
			BoundingBox () noexcept ;
			BoundingBox (nkMemory::BufferView<const nkMaths::Vector> points) noexcept ;
			BoundingBox (const nkMaths::Vector& center, float cubeHalfSide) noexcept ;
			BoundingBox (const nkMaths::Vector& center, const nkMaths::Vector& axisAlignedHalfSides) noexcept ;

			// Getters
			nkMemory::BufferView<const nkMaths::Vector> getPoints () const ;
			nkMemory::BufferView<const nkMaths::Vector> getTransformedPoints () const ;
			nkMaths::Vector getCenter () const ;
			nkMaths::Vector getTransformedCenter () const ;
			nkMaths::Vector getAxisAlignedSides () const ;

			// Setters
			void setPoints (nkMemory::BufferView<const nkMaths::Vector> points) ;
			void setTransformedPoints (nkMemory::BufferView<const nkMaths::Vector> points) ;

			// Updates
			void updateTransformation (const nkMaths::Matrix& transform) ;

			// Checks
			bool checkAgainst (const Frustum& frustum) const ;

		private :
		
			// Attributes
			// Bounds space points
			nkMaths::Vector _points [8] ;

			// Transformed points
			nkMaths::Vector _transformedPoints[8] ;
	} ;
}